MoreVehZones = MoreVehZones or {}

function MoreVehZones.changeVehZone(zoneX, zoneY, zoneZ, newName, newWidht, newHeight, newX, newY)
	local vz = getVehicleZoneAt(zoneX, zoneY, zoneZ)
	if vz ~= nil then
		if newName ~= nil then
			vz:setName(newName)
			vz:setOriginalName(newName)
		end
		if newWidht ~= nil then
			vz:setW(newWidht)
		end
		if newHeight ~= nil then
			vz:setH(newHeight)
		end
		if newX ~= nil then
			vz:setX(newX)
		end
		if newY ~= nil and newX ~= nil then
			local nvz = getVehicleZoneAt(newX, zoneY, zoneZ)
			nvz:setY(newY)
		elseif newY ~= nil then
			vz:setY(newY)
		end
	end
end

function MoreVehZones.changeVehZoneForVanilla(zoneX, zoneY, zoneZ, newName, newWidht, newHeight, newX, newY)
	local vz = getVehicleZoneAt(zoneX, zoneY, zoneZ)
	if vz ~= nil then
		if MoreVehZones.isModdedCell(math.floor(vz:getX()/256), math.floor(vz:getY()/256)) then return end
		if newName ~= nil then
			vz:setName(newName)
			vz:setOriginalName(newName)
		end
		if newWidht ~= nil then
			vz:setW(newWidht)
		end
		if newHeight ~= nil then
			vz:setH(newHeight)
		end
		if newX ~= nil then
			vz:setX(newX)
		end
		if newY ~= nil and newX ~= nil then
			local nvz = getVehicleZoneAt(newX, zoneY, zoneZ)
			nvz:setY(newY)
		elseif newY ~= nil then
			vz:setY(newY)
		end
	end
end

function MoreVehZones.removeVehZone(zoneX, zoneY, zoneZ)
	local vz = getVehicleZoneAt(zoneX, zoneY, zoneZ)
	if vz ~= nil then
		local cx = math.floor(vz:getX()/256)
		local cy = math.floor(vz:getY()/256)
		local cellData = getWorld():getMetaGrid():getCellData(cx, cy)
		local vehicleZonesField = getClassField(cellData, 0)
		if vehicleZonesField then
			local vehicleZones = getClassFieldVal(cellData, vehicleZonesField)
			if vehicleZones then
				for i=vehicleZones:size(), 1, -1 do
					local vehicleZone = vehicleZones:get(i-1)
					if vehicleZone:getName() == vz:getName() and vehicleZone:getX() == vz:getX() and vehicleZone:getY() == vz:getY() and vehicleZone:getZ() == vz:getZ() then
						vehicleZones:remove(vehicleZone)
						break
					end
				end
			end
		end
	end
end